﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Remoting;
using System.Net;
using System.Net.Sockets;
using System.Threading;

namespace Server
{
	class Program
	{
		private static readonly ServerActionHandler ServerActionHandler = new ServerActionHandler();

		static void Main(string[] args)
		{
			using (RServerSocketAcceptor acceptor = new RServerSocketAcceptor(IPAddress.Any, Config.PORT))
			{
				acceptor.Accepted += new Action<RServerSocket>(acceptor_Accepted);
				while (true)
				{
					Thread.Sleep(1000);
				}
			}
		}

		static void acceptor_Accepted(RServerSocket clientSocket)
		{
			ThreadPool.QueueUserWorkItem((object state) =>
			{
				if (!ServerActionHandler.HasFreeSlots())
				{
					// drop this new connection
					Console.WriteLine("Got too many clients, refused connection request from: {0}", clientSocket);
					return;
				}
				// got a new connection, begin to receive messages
				using (RMessagePipe clientPipe = new RMessagePipe(clientSocket))
				{
					bool alive = true;
					clientPipe.ExceptionCaught += (RMessagePipe pipe, Exception ex) =>
					{
						alive = false;
						ServerActionHandler.Unregister(clientPipe);
					};
					ServerActionHandler.Register(clientPipe);
					using (RProcessor processor = new RProcessor(clientPipe, ServerActionHandler))
					{
						while (alive)
						{
							// dispatch messages
							Thread.Sleep(1000);
						}
					}
				}
			});
		}
	}
}
